<?php

namespace App\Http\Controllers\Admin;

use Artisan;
use App\Models\Tag;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class TagController extends Controller
{
     // function __construct()
     // {
     //     $this->middleware('permission:tag-index|tag-create|tag-edit|tag-delete', ['only' => ['index','show']]);
     //     $this->middleware('permission:tag-create', ['only' => ['create','store']]);
     //     $this->middleware('permission:tag-edit', ['only' => ['edit','update']]);
     //     $this->middleware('permission:tag-delete', ['only' => ['destroy']]);
     // }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.tag.index');
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.tag.create'); 
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $tag= new Tag;
        $tag->name=$request->name;
        $tag->weight=$request->weight;
        $tag->slug=Str::slug($request->name,'-');
        $tag->save();
       
   session()->flash('success','Tag data sucesfully added');
   return redirect( route('tag.index') );
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tag=Tag::find($id);
        return view('admin.tag.edit',compact('tag'));
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $tag=Tag::find($id);
        $tag->name=$request->name;
        $tag->weight=$request->weight;
        $tag->slug=Str::slug($request->name,'-');
        $tag->save();
       
   session()->flash('success','Tag data sucesfully updated');
   return redirect( route('tag.index') );


        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $tag=Tag::find($id);

       if($tag->blogs()->count() > 0 ){

         session()->flash('error','Tags cannot deleted because it associated with some blogs so delete some blogs which is associated it');
            return redirect()->route('tag.index');
        }else{
        $tag->delete();


        session()->flash('error','Tags sucessfuly deleted');
        return redirect()->route('tag.index');

        
        }

}


public function status($id){
    $tag=Tag::find($id);  

  

 if($tag->maintain == 0){
      $tag->maintain= 1;
      Artisan::call('up');
    
  }else if($tag->maintain==1){
 
      $tag->maintain =0;
      Artisan::call('down');
}

  session()->flash('success','status has been succesfully updated');
  $tag->save();
  return redirect()->back();



}



}
